<?php
$installer = $this;

$installer->startSetup();

$code = 'auspost_package_type';
$package_type = Mage::getModel('catalog/resource_eav_attribute')->loadByCode('catalog_product', $code);
if (null === $package_type->getId()) {
	$installer->addAttribute('catalog_product', 'auspost_package_type', array(
		'label' => 'Australia Post Package Type',
		'group' => 'General',
		'input' => 'select',
		'type' => 'int',
		'visible' => 1,
		'required' => 0,
		'user_defined' => 1,
		'is_configurable' => 0,
		'source' => 'eav/entity_attribute_source_table',
		'backend' => 'eav/entity_attribute_backend_array',
		'option' => array(
			'values' => array(
				0 => 'Parcel',
				1 => 'Letter',

			)),
		'global' => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_GLOBAL,

	));
} else {
	$installer->updateAttribute('catalog_product', 'auspost_package_type', array(
		'is_configurable' => 0,
	));
}

// Insert a list of states into the regions database if not exist.
$regions = array(
	array('code' => 'ACT', 'name' => 'Australia Capital Territory'),
	array('code' => 'NSW', 'name' => 'New South Wales'),
	array('code' => 'NT', 'name' => 'Northern Territory'),
	array('code' => 'QLD', 'name' => 'Queensland'),
	array('code' => 'SA', 'name' => 'South Australia'),
	array('code' => 'TAS', 'name' => 'Tasmania'),
	array('code' => 'VIC', 'name' => 'Victoria'),
	array('code' => 'WA', 'name' => 'Western Australia'),
);

$db = Mage::getSingleton('core/resource')->getConnection('core_read');

foreach ($regions as $region) {
	// Check if this region has already been added
	$result = $db->fetchOne("SELECT code FROM " . $this->getTable('directory_country_region') . " WHERE `country_id` = 'AU' AND `code` = '" . $region['code'] . "'");
	if ($result != $region['code']) {
		$installer->run(
			"INSERT INTO `{$this->getTable('directory_country_region')}` (`country_id`, `code`, `default_name`) VALUES
            ('AU', '" . $region['code'] . "', '" . $region['name'] . "');
            INSERT INTO `{$this->getTable('directory_country_region_name')}` (`locale`, `region_id`, `name`) VALUES
            ('en_US', LAST_INSERT_ID(), '" . $region['name'] . "'), ('en_AU', LAST_INSERT_ID(), '" . $region['name'] . "');"
		);
	}
}

$installer->endSetup();